/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.save_world;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.downgrade.DowngradeVersion;
import com.moulberry.axiom.downgrade.DowngradeVersionList;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.schematic.SchematicLoader;
import com.moulberry.axiom.editor.windows.save_world.SaveSchematicAction;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.utils.AsyncFileDialogs;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImString;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.nio.file.Path;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2487;
import net.minecraft.class_310;

public class ExportSchematicWindow {
    private static boolean showingWindow = false;
    private static ChunkedBlockRegion blockRegion = null;
    private static Long2ObjectMap<CompressedBlockEntity> blockEntities = null;
    private static class_2487 additionalSchematicData = null;
    private static CompletableFuture<String> saveFileCompletableFuture = null;
    private static SaveSchematicAction saveSchematicAction = null;
    private static final ImString name = new ImString();
    private static final ImString author = new ImString();
    private static final int[] downgradeVersion = new int[]{0};

    public static void render() {
        String exportSchematic = "Export Schematic";
        if (!showingWindow) {
            if (ImGui.isPopupOpen(exportSchematic + "###ExportSchematic")) {
                ExportSchematicWindow.close();
            }
            return;
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 1, 0.5f, 0.5f);
        if (!ImGui.isPopupOpen(exportSchematic + "###ExportSchematic")) {
            ImGui.openPopup("###ExportSchematic");
        }
        if (ImGuiHelper.beginPopupModalCloseable(exportSchematic + "###ExportSchematic", 68)) {
            if (saveFileCompletableFuture != null && saveFileCompletableFuture.isDone()) {
                String filePath = saveFileCompletableFuture.join();
                saveFileCompletableFuture = null;
                if (filePath != null) {
                    ExportSchematicWindow.save(filePath);
                    if (saveSchematicAction == null) {
                        ExportSchematicWindow.close();
                        ImGui.closeCurrentPopup();
                        ImGui.endPopup();
                        return;
                    }
                }
            }
            if (saveSchematicAction != null && saveSchematicAction.render()) {
                saveSchematicAction = null;
                ExportSchematicWindow.close();
                ImGui.closeCurrentPopup();
                ImGui.endPopup();
                return;
            }
            String[] versionStrings = DowngradeVersionList.getVersionStrings();
            if (versionStrings != null && versionStrings.length > 0) {
                if (!Axiom.getInstance().hasCommercialLicense()) {
                    ImGui.beginDisabled();
                    ImGuiHelper.combo("Version", downgradeVersion, versionStrings);
                    ImGui.endDisabled();
                    ImGuiHelper.tooltip("Exporting to old versions is a Commercial License feature", 512);
                } else {
                    ImGuiHelper.combo("Version", downgradeVersion, versionStrings);
                }
            } else if (Axiom.getInstance().hasCommercialLicense()) {
                ImGui.text("\u26a0 Missing data for 1.20.1. Version exporting is unavailable.");
            }
            String username = class_310.method_1551().field_1724.method_5820();
            ImGui.inputText(AxiomI18n.get("axiom.editorui.window.create_blueprint.name"), name);
            ImGui.inputTextWithHint(AxiomI18n.get("axiom.editorui.window.create_blueprint.author"), username, author);
            boolean save = ImGui.button(AxiomI18n.get("axiom.editorui.window.create_blueprint.save"));
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"))) {
                ExportSchematicWindow.close();
                ImGui.closeCurrentPopup();
                ImGui.endPopup();
                return;
            }
            if (save) {
                try {
                    Path schematicDir = SchematicLoader.getDefaultSchematicDir();
                    DowngradeVersion version = null;
                    if (Axiom.getInstance().hasCommercialLicense()) {
                        version = DowngradeVersionList.getVersions().get(downgradeVersion[0]);
                    }
                    String extension = version == null || version.getDataVersion() >= 1631 ? "schem" : "schematic";
                    String blueprintNameString = ImGuiHelper.getString(name).trim();
                    Object snakeName = blueprintNameString.isEmpty() ? "unnamed." + extension : blueprintNameString.toLowerCase(Locale.ROOT).replace(' ', '_') + "." + extension;
                    String separator = schematicDir.getFileSystem().getSeparator();
                    snakeName = ((String)snakeName).replace("/", "_").replace(separator, "_");
                    saveFileCompletableFuture = AsyncFileDialogs.saveFileDialog(schematicDir.toString(), (String)snakeName, "Schematic Files", extension);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ImGuiHelper.endPopupModalCloseable();
        }
        if (!ImGui.isPopupOpen(exportSchematic + "###ExportSchematic")) {
            ExportSchematicWindow.close();
        }
    }

    private static void save(String filePathName) {
        String schematicNameStr;
        String authorNameStr;
        filePathName = filePathName.replace(".schem.schem", ".schem");
        filePathName = filePathName.replace(".schematic.schematic", ".schematic");
        Path path = Path.of(filePathName, new String[0]);
        DowngradeVersion version = null;
        if (Axiom.getInstance().hasCommercialLicense()) {
            version = DowngradeVersionList.getVersions().get(downgradeVersion[0]);
        }
        if ((authorNameStr = ImGuiHelper.getString(author).trim()).isEmpty()) {
            String string = authorNameStr = class_310.method_1551().field_1724 == null ? "Unknown" : class_310.method_1551().field_1724.method_5820();
        }
        if ((saveSchematicAction = new SaveSchematicAction(path, blockRegion, blockEntities, version, schematicNameStr = ImGuiHelper.getString(name), authorNameStr, additionalSchematicData)).run()) {
            saveSchematicAction = null;
        }
    }

    public static void open(ChunkedBlockRegion blockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities, class_2487 additionalSchematicData) {
        showingWindow = true;
        ExportSchematicWindow.blockRegion = blockRegion;
        ExportSchematicWindow.blockEntities = blockEntities;
        ExportSchematicWindow.additionalSchematicData = additionalSchematicData;
        saveFileCompletableFuture = null;
    }

    private static void close() {
        saveFileCompletableFuture = null;
        showingWindow = false;
        blockRegion = null;
        blockEntities = null;
        additionalSchematicData = null;
    }
}

